/* _Scanf function */
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "xstdio.h"
#include "xwchar.h"
_STD_BEGIN

int _Scanf(int (*pfn)(void *, int, int), void *arg,
	const char *fmt, va_list ap)
	{	/* read formatted */
	int nconv = 0;
	_Sft x;
	_Mbstinit(mbst);

	x.pfn = pfn;
	x.arg = arg;
	_Vacopy(&x.ap, ap);
	x.nchar = 0;
	for (x.s = fmt; ; ++x.s)
		{	/* parse format string */
		int ch;

		for (; ; )
			{	/* match any literal text or white-space */
			int n;
			wchar_t wc = L'\0';

			if ((n = _Mbtowc(&wc, x.s, INT_MAX, &mbst)) <= 0)
				n = *x.s == '\0' ? 0 : 1;	/* bad parse, eat one char */
			if (isspace(_Wctob(wc)))
				{	/* match any white-space */
				while (isspace(ch = GET(&x)))
					;
				UNGETN(&x, ch);
				}
			else
				{	/* match any literal text */
				int m = wc == L'%' ? n - 1 : n;
				const char *s;

				for (s = x.s; 0 <= --m; ++s)
					if ((ch = GET(&x)) != *s)
						{	/* bad match */
						UNGETN(&x, ch);
						return (nconv);
						}
				}
			x.s += n;
			if (wc == L'%')
				break;
			else if (wc == L'\0')
				return (nconv);
			}
		 {	/* process a conversion specifier */
		int code;

		x.noconv = (char)(*x.s == '*' ? *x.s++ : '\0');
		for (x.width = 0; isdigit((unsigned char)*x.s); ++x.s)
			if (x.width < _WMAX)
				x.width = x.width * 10 + (unsigned char)*x.s - '0';
		x.qual = (char)(strchr("hjltzL", *x.s) ? *x.s++ : '\0');
		if (x.qual == 'h' && *x.s == 'h')
			x.qual = 'b', ++x.s;
		else if (x.qual == 'l' && *x.s == 'l')
			x.qual = 'q', ++x.s;
		if (!strchr("cCn[", *x.s))
			{	/* match leading white-space */
			while (isspace(ch = GET(&x)))
				;
			UNGETN(&x, ch);
			}
		if ((code = _Getfld(&x)) <= 0)
			return (nconv == 0 ? code : nconv);
		if (x.stored)
			++nconv;
		 }
		}
		}
_STD_END

/*
 * Copyright (c) 1992-2003 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V4.02:1422 */
